function [h,u,v] = GeostrophicFcn(x,y)

    global gravity omega phi0

    % Background height
    h0 = 500.0;
    
    % Background velocity
    u0 = 30.0;

    % Latitude (override)
    phi = pi/4;

    % Coriolis parameter (override)
    f = 2.0 * omega * sin(phi);
    
    % Wavelength
    lambda = 1.0e6;

    % Height of the hill at this point
    h = h0 + u0 * f / gravity * lambda / (2.0 * pi) * cos(2.0 * pi * y / lambda);

    % Fixed zonal velocity
    u = u0 * sin(2.0 * pi * y / lambda);
    
    % Zero meridional velocity
    v = 0;

end