function AnimateShallowWater(X,Y,T,M)

% Height field level list
%hlevels = [0.5:0.1:1.0];
%ulevels = [-0.5:0.1:0.5];

hmin = min(min(min(M(:,:,1,:))));
hmax = max(max(max(M(:,:,1,:))));
hlevels = [hmin:(hmax-hmin)/10:hmax];

umin = min(min(min(M(:,:,2,:))));
umax = max(max(max(M(:,:,2,:))));
ulevels = [umin:(umax-umin)/10:umax];

vmin = min(min(min(M(:,:,3,:))));
vmax = max(max(max(M(:,:,3,:))));
vlevels = [vmin:(vmax-vmin)/10:vmax];

% Set up the figure window
hf = figure(1);
set(hf, 'Position', [100 100 1000 300]);

% Create mesh grid
[Xx, Yy] = meshgrid(X,Y);

% Loop through all times
for t = 1:size(M,4)

    % Clear the figure
    clf;
    
    % Plot fluid height
    subplot(1,3,1);
    %surf(Xx, Yy, M(:,:,1,t));
    %axis([min(X) max(X) min(Y) max(Y) hmin hmax]);
    contourf(Xx, Yy, M(:,:,1,t), 'LevelList', hlevels);
    axis([min(X) max(X) min(Y) max(Y)]);
    title('Fluid height (m)');
    colorbar('SouthOutside');
    caxis([min(hlevels) max(hlevels)]);

    % Plot zonal velocity
    subplot(1,3,2);
    contourf(Xx, Yy, M(:,:,2,t), 'LevelList', ulevels);
    axis([min(X) max(X) min(Y) max(Y)]);
    title('Zonal fluid velocity (m / s)');
    colorbar('SouthOutside');
    caxis([min(ulevels) max(ulevels)]);

    % Plot meridional velocity
    subplot(1,3,3);
    contourf(Xx, Yy, M(:,:,3,t), 'LevelList', vlevels);
    axis([min(X) max(X) min(Y) max(Y)]);
    title('Meridional fluid velocity (m / s)');
    colorbar('SouthOutside');
    caxis([min(vlevels) max(vlevels)]);

    % Draw now
    drawnow;
end

end