function AnimateShallowWaterQuiver(X,Y,T,M)

% Height field level list
hlevels = [0.5:0.1:1.0];
ulevels = [-0.5:0.1:0.5];

% Set up the figure window
hf = figure(1);
set(hf, 'Position', [100 100 800 800]);

% Create mesh grid
[Xx, Yy] = meshgrid(X,Y);

% Loop through all times
for t = 1:size(M,4)
    
    % Clear the figure
    clf;

    % Quiver
    quiver(X, Y, M(:,:,2,t), M(:,:,3,t));
    axis([min(X) max(X) min(Y) max(Y)]);

    % Draw now
    drawnow;
end

end