function [h,u,v] = GradientFcn(x,y)

global gravity

    % Radius from the center of the hill
    r = sqrt(x^2 + y^2);
    
    % Angle from the center of the hill
    theta = atan2(y,x);

    % Half-width of the hill
    R0 = 2.0e5;
    
    % Fluid height perturbation
    hp = 20.0;

    % Background fluid height
    h0 = 500.0;

    % Calculate fluid height
    h = h0 - hp * exp(- r^2 / R0^2);

    % Rotational velocity
    uphi = sqrt(gravity * hp * (2 * r^2 / R0^2) * exp(- r^2 / R0^2));

    if (r == 0)
        u = 0;
        v = 0;
    else
        u = - sin(theta) * uphi;
        v = cos(theta) * uphi;
    end
end