function [h,u,v] = GaussianFcn(x,y)

    % Radius from the center of the hill
    r = sqrt(x^2 + y^2);

    % Half-width of the hill
    R0 = 4.0e5;

    % Fluid height perturbation
    hp = 5.0;

    % Height of the hill at this point
    h = 500.0 + hp * exp(- r^2 / R0^2);

    % Zero velocity
    u = 0;
    v = 0;

end